<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class City extends Model 
{

    protected $table = 'cities';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_ar', 'name_en', 'is_active', 'country_id');

    public function country()
    {
        return $this->belongsTo('Country');
    }

    public function districts()
    {
        return $this->hasMany('District');
    }

}